/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDSimpleTypeTraverser
extends XSDAbstractTraverser {
    private String fListName = "";
    private int fSimpleTypeAnonCount = 0;
    private final QName fQName = new QName();
    private final SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    XSDSimpleTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSSimpleType traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XSSimpleType type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar, true);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (nameAtt == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, SchemaSymbols.ATT_NAME}, elmNode);
        }
        return type;
    }

    XSSimpleType traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        XSSimpleType type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar, false);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private XSSimpleType traverseSimpleTypeDecl(Element simpleTypeDecl, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar, boolean isGlobal) {
        qualifiedName = nameProperty = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        qualifiedName = nameProperty == null ? (schemaDoc.fTargetNamespace == null ? ",#s#" + this.fSimpleTypeAnonCount++ : schemaDoc.fTargetNamespace + ",#S#" + this.fSimpleTypeAnonCount++) : (schemaDoc.fTargetNamespace == null ? "," + nameProperty : schemaDoc.fTargetNamespace + "," + nameProperty);
        finalAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        finalProperty = finalAttr == null ? schemaDoc.fFinalDefault : finalAttr.intValue();
        content = DOMUtil.getFirstChildElement(simpleTypeDecl);
        if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (content == null) {
            this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"}, simpleTypeDecl);
            return null;
        }
        contentAttrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
        this.fAttrChecker.returnAttrArray(contentAttrs, schemaDoc);
        varietyProperty = DOMUtil.getLocalName(content);
        baseTypeName = null;
        memberTypes = null;
        dTValidators = null;
        size = 0;
        list = false;
        union = false;
        restriction = false;
        numOfTypes = 0;
        if (varietyProperty.equals(SchemaSymbols.ELT_LIST)) {
            baseTypeName = (QName)contentAttrs[XSAttributeChecker.ATTIDX_ITEMTYPE];
            list = true;
            if (this.fListName.length() != 0) {
                this.reportCosListOfAtomic(qualifiedName, simpleTypeDecl);
                return null;
            }
            this.fListName = qualifiedName;
        } else if (varietyProperty.equals(SchemaSymbols.ELT_RESTRICTION)) {
            baseTypeName = (QName)contentAttrs[XSAttributeChecker.ATTIDX_BASE];
            restriction = true;
        } else if (varietyProperty.equals(SchemaSymbols.ELT_UNION)) {
            union = true;
            memberTypes = (Vector)contentAttrs[XSAttributeChecker.ATTIDX_MEMBERTYPES];
            size = memberTypes != null ? memberTypes.size() : 1;
            dTValidators = new Vector<XSSimpleType>(size, 2);
        } else {
            args = new Object[]{varietyProperty};
            this.reportSchemaError("dt-unsupported-derivation", args, content);
        }
        if (DOMUtil.getNextSiblingElement(content) != null) {
            this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"}, content);
        }
        baseValidator = null;
        if (baseTypeName != null || memberTypes != null) ** GOTO lbl75
        contentTmp = DOMUtil.getFirstChildElement(content);
        if (contentTmp != null && DOMUtil.getLocalName(contentTmp).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(contentTmp, attrValues, false, schemaDoc);
            contentTmp = DOMUtil.getNextSiblingElement(contentTmp);
        }
        if (contentTmp == null) {
            this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"}, content);
            return null;
        }
        content = contentTmp;
        if (DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            baseValidator = this.traverseLocal(content, schemaDoc, grammar);
            if (baseValidator != null && union) {
                if (baseValidator.getVariety() == 3) {
                    types = ((XSUnionSimpleType)baseValidator).getMemberTypes();
                    i = 0;
                    while (i < types.length) {
                        dTValidators.addElement(types[i]);
                        ++i;
                    }
                } else {
                    dTValidators.addElement(baseValidator);
                }
            }
            if (baseValidator == null) {
                args = new Object[]{content.getAttribute(SchemaSymbols.ATT_BASE)};
                this.reportSchemaError("dt-unknown-basetype", args, content);
                return SchemaGrammar.fAnySimpleType;
            }
        } else {
            args = new Object[]{simpleTypeDecl.getAttribute(SchemaSymbols.ATT_NAME)};
            this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"}, content);
            return SchemaGrammar.fAnySimpleType;
lbl75:
            // 1 sources

            numOfTypes = 1;
            if (union) {
                numOfTypes = size;
            }
            baseRefContext = restriction != false ? 2 : (union != false ? 4 : 8);
            i = 0;
            while (i < numOfTypes) {
                if (union) {
                    baseTypeName = (QName)memberTypes.elementAt(i);
                }
                if ((baseValidator = this.findDTValidator(simpleTypeDecl, baseTypeName, baseRefContext, schemaDoc)) == null) {
                    args = new Object[]{content.getAttribute(SchemaSymbols.ATT_BASE), nameProperty};
                    this.reportSchemaError("dt-unknown-basetype", args, simpleTypeDecl);
                    baseValidator = SchemaGrammar.fAnySimpleType;
                }
                if (this.fListName.length() != 0) {
                    if (baseValidator.getVariety() == 2) {
                        this.reportCosListOfAtomic(qualifiedName, simpleTypeDecl);
                        return null;
                    }
                    if (this.isListDatatype(baseValidator)) {
                        this.reportCosListOfAtomic(qualifiedName, simpleTypeDecl);
                        return null;
                    }
                }
                if (union) {
                    if (baseValidator.getVariety() == 3) {
                        types = ((XSUnionSimpleType)baseValidator).getMemberTypes();
                        j = 0;
                        while (j < types.length) {
                            dTValidators.addElement(types[j]);
                            ++j;
                        }
                    } else {
                        dTValidators.addElement(baseValidator);
                    }
                }
                ++i;
            }
        }
        if (baseTypeName == null) {
            content = DOMUtil.getNextSiblingElement(content);
        } else if ((content = DOMUtil.getFirstChildElement(content)) != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (union) {
            if (memberTypes != null) {
                if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                    content = DOMUtil.getNextSiblingElement(content);
                }
                if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    args = new Object[]{nameProperty};
                    this.reportSchemaError("dt-union-memberType", args, content);
                }
            }
            while (content != null) {
                baseValidator = this.traverseLocal(content, schemaDoc, grammar);
                if (baseValidator != null) {
                    if (this.fListName.length() != 0 && baseValidator.getVariety() == 2) {
                        this.reportCosListOfAtomic(qualifiedName, content);
                        return null;
                    }
                    if (baseValidator.getVariety() == 3) {
                        types = ((XSUnionSimpleType)baseValidator).getMemberTypes();
                        i = 0;
                        while (i < types.length) {
                            dTValidators.addElement(types[i]);
                            ++i;
                        }
                    } else {
                        dTValidators.addElement(baseValidator);
                    }
                }
                if (baseValidator == null) {
                    args = new Object[]{content.getAttribute(SchemaSymbols.ATT_BASE), nameProperty};
                    this.reportSchemaError("dt-unknown-basetype", args, content);
                    baseValidator = SchemaGrammar.fAnySimpleType;
                }
                content = DOMUtil.getNextSiblingElement(content);
            }
        }
        if (this.fListName.length() != 0 && this.fListName.equals(qualifiedName)) {
            this.fListName = "";
        }
        facetData = null;
        presentFacets = 0;
        fixedFacets = 0;
        if (restriction && content != null) {
            fi = this.traverseFacets(content, contentAttrs, nameProperty, baseValidator, schemaDoc, grammar);
            content = fi.nodeAfterFacets;
            if (content != null) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_RESTRICTION, "(annotation?, (simpleType?, (minExclusive | minInclusive | maxExclusive | maxInclusive | totalDigits | fractionDigits | length | minLength | maxLength | enumeration | whiteSpace | pattern)*))"}, content);
                content = null;
            }
            facetData = fi.facetdata;
            presentFacets = fi.fPresentFacets;
            fixedFacets = fi.fFixedFacets;
        } else if (list && content != null) {
            if (baseTypeName != null) {
                if (DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                    content = DOMUtil.getNextSiblingElement(content);
                }
                if (content != null) {
                    args = new Object[]{nameProperty};
                    this.reportSchemaError("dt-list-itemType", args, content);
                }
            } else {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType?))"}, content);
            }
        } else if (union && content != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_UNION, "(annotation?, (simpleType?))"}, content);
        }
        newDecl /* !! */  = null;
        if (list) {
            newDecl /* !! */  = this.schemaFactory.createTypeList(nameProperty, schemaDoc.fTargetNamespace, (short)finalProperty, baseValidator);
        } else if (restriction) {
            newDecl /* !! */  = this.schemaFactory.createTypeRestriction(nameProperty, schemaDoc.fTargetNamespace, (short)finalProperty, baseValidator);
            try {
                this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                newDecl /* !! */ .applyFacets(facetData, presentFacets, fixedFacets, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException ex) {
                this.reportSchemaError(ex.getKey(), ex.getArgs(), simpleTypeDecl);
            }
        } else {
            memberDecls = new XSSimpleType[dTValidators.size()];
            i = 0;
            while (i < dTValidators.size()) {
                memberDecls[i] = (XSSimpleType)dTValidators.elementAt(i);
                ++i;
            }
            newDecl /* !! */  = this.schemaFactory.createTypeUnion(nameProperty, schemaDoc.fTargetNamespace, (short)finalProperty, memberDecls);
        }
        if (nameProperty == null && isGlobal) {
            return null;
        }
        if (newDecl /* !! */  != null && isGlobal) {
            grammar.addGlobalTypeDecl(newDecl /* !! */ );
        }
        return newDecl /* !! */ ;
    }

    private void reportCosListOfAtomic(String qualifiedName, Element elem) {
        this.fListName = "";
        this.reportSchemaError("cos-list-of-atomic", new Object[]{qualifiedName}, elem);
    }

    private XSSimpleType findDTValidator(Element elm, QName baseTypeStr, short baseRefContext, XSDocumentInfo schemaDoc) {
        if (baseTypeStr == null) {
            return null;
        }
        if (baseTypeStr.uri != null && baseTypeStr.uri.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA) && (baseTypeStr.localpart.equals("anySimpleType") || baseTypeStr.localpart.equals("anyType")) && baseRefContext == 2) {
            this.reportSchemaError("dt-unknown-basetype", new Object[]{baseTypeStr.rawname, DOMUtil.getAttrValue(elm, SchemaSymbols.ATT_NAME)}, elm);
            return SchemaGrammar.fAnySimpleType;
        }
        XSTypeDecl baseType = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeStr, elm);
        if (baseType != null) {
            if (baseType.getXSType() != 2) {
                this.reportSchemaError("st-props-correct.4.1", new Object[]{baseTypeStr.rawname}, elm);
                return SchemaGrammar.fAnySimpleType;
            }
            if ((baseType.getFinalSet() & baseRefContext) != 0) {
                this.reportSchemaError("dt-restiction-final", new Object[]{baseTypeStr.rawname}, elm);
            }
        }
        return (XSSimpleType)baseType;
    }

    private boolean isListDatatype(XSSimpleType validator) {
        if (validator.getVariety() == 2) {
            return true;
        }
        if (validator.getVariety() == 3) {
            XSSimpleType[] temp = ((XSUnionSimpleType)validator).getMemberTypes();
            int i = 0;
            while (i < temp.length) {
                if (temp[i].getVariety() == 2) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

