/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.DateObject;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Param;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.tds.CapabilitySet;
import com.sybase.jdbc2.tds.DataFormat;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.ByteArrayInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsParam
extends Param {
    private static final String NULL = "null";
    private static final String ZERO = "0";
    private static final String QUOTE = "'";
    private static final String HEX_START = "0x";
    private static final String ASCII_ENCODING = "ISO8859_1";
    protected DataFormat _inDataFmt;
    byte[] _cvtString = null;
    protected String _parameterAsAString = null;
    protected boolean _paramIsLittleEndian = false;
    protected boolean _parameterHoldsUnicharData = false;
    protected TdsDataOutputStream _tdos = null;

    protected TdsParam() {
    }

    public TdsParam(TdsDataOutputStream tdsDataOutputStream) {
        this._tdos = tdsDataOutputStream;
    }

    protected void clear(boolean bl) throws IOException {
        this._sendAsLiteral = false;
        this._cvtString = null;
        this._parameterAsAString = null;
        if (bl) {
            this._sqlType = -999;
            this._regType = -999;
            this._inValue = null;
            this._scale = -999;
        }
        if (this._outValue != null) {
            ((TdsJdbcInputStream)this._outValue).clear();
            this._outValue = null;
        }
    }

    protected int getCharCount() throws IOException {
        InputStream inputStream = (InputStream)this._inValue;
        int n = this._scale;
        if (this._scale == -1) {
            n = inputStream.available();
            n /= 2;
        }
        return n;
    }

    protected int getLength() {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            return this._inDataFmt.length();
        }
        return 0;
    }

    protected String getStringFromStream(int n) throws IOException {
        InputStream inputStream = (InputStream)this._inValue;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this._scale;
        if (n2 != -1 && n2 % 2 != 0) {
            --n2;
        }
        while (n2 != 0) {
            int n3;
            int n4 = inputStream.read();
            if (n4 == -1 || (n3 = inputStream.read()) == -1) break;
            char c = (char)(n4 << 8 | n3);
            stringBuffer.append(c);
            n2 -= 2;
        }
        return stringBuffer.toString();
    }

    public String literalValue(Protocol protocol, int n, int n2) throws IOException {
        Tds tds = (Tds)protocol;
        switch (this._sqlType) {
            case -7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return (Boolean)this._inValue != false ? "1" : ZERO;
            }
            case -6: 
            case 4: 
            case 5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Integer)this._inValue).toString();
            }
            case -5: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Long)this._inValue).toString();
            }
            case 2: 
            case 3: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((BigDecimal)this._inValue).toString();
            }
            case 7: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return ((Float)this._inValue).toString();
            }
            case 6: 
            case 8: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer stringBuffer = new StringBuffer("convert(float(32), ");
                stringBuffer.append(((Double)this._inValue).toString());
                stringBuffer.append(")");
                return stringBuffer.toString();
            }
            case 91: 
            case 92: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(false) + QUOTE;
            }
            case 93: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                return QUOTE + ((DateObject)this._inValue).format(true) + QUOTE;
            }
            case -1: 
            case 1: 
            case 12: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                StringBuffer stringBuffer = null;
                if (this._inValue instanceof String) {
                    int n3 = ((String)this._inValue).length();
                    stringBuffer = new StringBuffer(n3 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(((String)this._inValue).substring(0, n3));
                } else if (this._inValue instanceof InputStream) {
                    int n4 = this.getCharCount();
                    stringBuffer = new StringBuffer(n4 + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this.getStringFromStream(n2));
                } else if (this._inValue instanceof Reader) {
                    int[] nArray = new int[4];
                    this._tdos.convertString(this, nArray);
                    stringBuffer = new StringBuffer(nArray[1] + 2);
                    stringBuffer.append(QUOTE);
                    stringBuffer.append(this._parameterAsAString);
                }
                int n5 = 1;
                int n6 = stringBuffer.length();
                while ((n5 = stringBuffer.toString().indexOf(39, n5)) != -1) {
                    stringBuffer.insert(n5, '\'');
                    if ((n5 += 2) <= ++n6) continue;
                }
                stringBuffer.append(QUOTE);
                return stringBuffer.toString();
            }
            case -4: 
            case -3: 
            case -2: {
                if (!this._sendAsLiteral) break;
                if (this._inValue == null) {
                    return NULL;
                }
                if (this._inValue instanceof byte[]) {
                    return HEX_START + HexConverts.hexConvert((byte[])this._inValue);
                }
                InputStream inputStream = (InputStream)this._inValue;
                int n7 = this._scale;
                if (this._scale == -1) {
                    n7 = inputStream.available();
                }
                byte[] byArray = new byte[n7];
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = inputStream.read(byArray, n8, n7 - n8);
                    if (n9 == -1) break;
                    n8 += n9;
                }
                return HEX_START + HexConverts.hexConvert(byArray);
            }
            case 2000: {
                if (!this._sendAsLiteral) break;
                ErrorMessage.raiseIOException("JZ0ST");
                break;
            }
        }
        return "@p" + n;
    }

    protected boolean makeFormat(Protocol protocol) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt = new DataFormat(this, ((Tds)protocol)._out);
            return true;
        }
        return false;
    }

    protected void prepareForSend(Protocol protocol, int n, boolean bl) throws SQLException {
        Tds tds = (Tds)protocol;
        CapabilitySet capabilitySet = tds._capT._reqCaps;
        if (this._sqlType == -999) {
            this._inValue = null;
            this._sqlType = this._regType;
        }
        if (this._sqlType == -999) {
            ErrorMessage.raiseError("JZ0SA", String.valueOf(n));
        }
        switch (this._regType) {
            case -4: {
                if (tds._sendLongAnyway) {
                    this._sendAsLiteral = false;
                }
            }
            case -1: {
                this._sqlType = this._regType;
                break;
            }
        }
        if (!bl && tds._sendLiterals) {
            this._sendAsLiteral = true;
            return;
        }
        switch (this._sqlType) {
            case -5: {
                if (capabilitySet.get(51)) break;
                if (this._inValue != null) {
                    long l = (Long)this._inValue;
                    if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                        this._inValue = new BigDecimal(String.valueOf(l));
                        this._sqlType = 2;
                        if (capabilitySet.get(24)) break;
                        this._sendAsLiteral = true;
                        break;
                    }
                    this._inValue = new Integer((int)l);
                }
                this._sqlType = 4;
            }
            case 4: {
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -7: {
                if (capabilitySet.get(13)) break;
                if (this._inValue != null) {
                    this._inValue = new Integer((Boolean)this._inValue != false ? 1 : 0);
                }
                this._sqlType = -6;
            }
            case -6: {
                if (this._inValue != null && (Integer)this._inValue >= 0 && capabilitySet.get(10)) break;
                this._sqlType = 5;
            }
            case 5: {
                if (capabilitySet.get(11)) break;
                this._sqlType = 4;
                if (capabilitySet.get(12)) break;
                this._sendAsLiteral = true;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                Object object;
                if (this._sqlType == 1 || this._sqlType == 12 || this._inValue == null) {
                    object = new int[4];
                    try {
                        this._tdos.convertString(this, (int[])object);
                        if (this._parameterHoldsUnicharData) {
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        ErrorMessage.raiseErrorCheckDead(iOException);
                    }
                    if (object[1] <= 255) {
                        if (this._sqlType == 1 && capabilitySet.get(14) || this._sqlType == -1 && capabilitySet.get(28) && this.sendingLongcharIsOK(protocol)) break;
                        if (capabilitySet.get(15)) {
                            this._sqlType = 12;
                            break;
                        }
                    }
                }
                if (this._tdos._tds.isUnicharEnabled() && (!(this._inValue instanceof Reader) || this._inValue instanceof InputStreamReader && !((InputStreamReader)this._inValue).getEncoding().equals(ASCII_ENCODING))) break;
                if ((this._inValue instanceof InputStream || this._inValue instanceof Reader) && capabilitySet.get(55)) {
                    if (this._scale != -1 && this._scale <= 255 && capabilitySet.get(15)) {
                        this._sqlType = 12;
                        break;
                    }
                    this._sqlType = 9219;
                    break;
                }
                if (capabilitySet.get(28) && this.sendingLongcharIsOK(protocol)) {
                    this._sqlType = -1;
                    break;
                }
                if (capabilitySet.get(55)) {
                    object = new ByteArrayInputStream(this.stringToUnicodeBytes(this._parameterAsAString));
                    if (!this._tdos.getBigEndian()) {
                        this._paramIsLittleEndian = true;
                    }
                    this._sqlType = 9219;
                    this._inValue = object;
                    this._scale = this._parameterAsAString.length();
                    break;
                }
                this._sendAsLiteral = true;
                break;
            }
            case -4: {
                if (this._inValue instanceof InputStream && capabilitySet.get(57)) {
                    this._sqlType = 9220;
                    break;
                }
                if (capabilitySet.get(29) && this.sendingLongbinIsOK(protocol) || tds._sendLongAnyway) break;
                this._sendAsLiteral = true;
                break;
            }
            case -2: {
                if (capabilitySet.get(16)) break;
                this._sqlType = -3;
            }
            case -3: {
                if (capabilitySet.get(17)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 3: {
                if (capabilitySet.get(27)) break;
                this._sqlType = 2;
            }
            case 2: {
                if (capabilitySet.get(24)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 7: {
                if (capabilitySet.get(22)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 6: 
            case 8: {
                if (capabilitySet.get(23)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (capabilitySet.get(20)) break;
                this._sendAsLiteral = true;
                break;
            }
            case 2000: {
                if (capabilitySet.get(54) && !this._sendAsLiteral) break;
                ErrorMessage.raiseError("JZ0ST");
                break;
            }
        }
        if (bl && this._sendAsLiteral) {
            ErrorMessage.raiseError("JZ0SM");
        }
    }

    protected void send(OutputStream outputStream, int n) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            ((TdsDataOutputStream)outputStream).writeParam(this, n);
        }
    }

    protected void sendFormat(DataOutput dataOutput) throws IOException {
        if (this._sqlType != -998 && !this._sendAsLiteral) {
            this._inDataFmt.send((TdsOutputStream)dataOutput);
        }
    }

    private boolean sendingLongbinIsOK(Protocol protocol) throws SQLException {
        int n;
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        if (this._inValue != null) {
            if (this._inValue instanceof byte[]) {
                n2 = ((byte[])this._inValue).length;
            } else if (this._inValue instanceof InputStream) {
                if (this._scale == -1) {
                    bl2 = true;
                } else {
                    n2 = this._scale;
                }
            }
        }
        if (n2 > (n = ((Tds)protocol).getMaxLongvarbinaryLength()) || bl2 && n != Integer.MAX_VALUE) {
            bl = false;
        }
        return bl;
    }

    private boolean sendingLongcharIsOK(Protocol protocol) throws SQLException {
        boolean bl = true;
        int[] nArray = new int[4];
        try {
            this._tdos.convertString(this, nArray);
        }
        catch (IOException iOException) {
            ErrorMessage.raiseErrorCheckDead(iOException);
        }
        int n = ((Tds)protocol).getMaxLongvarcharLength();
        if (nArray[1] > n) {
            bl = false;
        }
        return bl;
    }

    protected byte[] stringToUnicodeBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = this._tdos.getBigEndian() ? string.getBytes("UnicodeBigUnmarked") : string.getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return byArray;
    }
}

