/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.CapabilitySet;
import com.sybase.jdbc2.tds.CapabilityToken;
import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SrvCapabilityToken
extends CapabilityToken
implements Dumpable {
    protected static Hashtable _datamap = new Hashtable();

    static {
        int[][] nArrayArray = new int[][]{{50, 7}, {45, 10}, {37, 11}, {225, 23}, {47, 8}, {39, 9}, {175, 22}, {48, 4}, {52, 5}, {56, 6}, {48, 4}, {38, 24}, {59, 16}, {62, 17}, {106, 21}, {108, 18}, {122, 13}, {60, 12}, {110, 26}, {58, 15}, {61, 14}, {111, 25}, {35, 19}, {34, 20}, {103, 31}, {9217, 36}, {9219, 37}, {9220, 39}};
        int n = 0;
        while (n < nArrayArray.length) {
            _datamap.put(new Integer(nArrayArray[n][0]), nArrayArray[n]);
            ++n;
        }
    }

    public SrvCapabilityToken() {
    }

    public SrvCapabilityToken(TdsInputStream tdsInputStream) throws IOException, SQLException {
        super(tdsInputStream);
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(226)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "CAPABILITY Token (0x" + HexConverts.hexConvert(226, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "CAPABILITY Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLen);
            }
            if (dumpFilter.includesDetail(3)) {
                Enumeration enumeration = this._allCapSets.elements();
                while (enumeration.hasMoreElements()) {
                    CapabilitySet capabilitySet = (CapabilitySet)enumeration.nextElement();
                    dumpInfo.addInfo("Type", 1, capabilitySet._type == 1 ? "CAP_REQUEST" : "CAP_RESPONSE");
                    String string = dumpFilter.includesDetail(4) ? this.maskToVerboseString(capabilitySet) : this.maskToString(capabilitySet);
                    dumpInfo.addInfo("Mask", capabilitySet._maskLen, string);
                }
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 226;
    }

    public boolean handlesDataType(int n) {
        Object v = _datamap.get(new Integer(n));
        if (v == null) {
            return false;
        }
        return this._respCaps.get(((int[])v)[1]) ^ true;
    }

    protected String maskToString(CapabilitySet capabilitySet) {
        String string = "";
        int n = 1;
        while (n <= capabilitySet._maskLen) {
            int n2 = 0;
            int n3 = 7;
            while (n3 >= 0) {
                if (capabilitySet._caps.get(n3)) {
                    n2 |= 1 << n3;
                }
                --n3;
            }
            string = String.valueOf(string) + "0x" + Integer.toHexString(n2) + " ";
            ++n;
        }
        return string;
    }

    protected void setDefaultServerCapabilities() {
        this._reqCaps.clear(3);
        this._reqCaps.clear(4);
        this._reqCaps.clear(5);
        this._reqCaps.clear(6);
        this._reqCaps.clear(7);
        this._reqCaps.clear(18);
        this._reqCaps.clear(19);
        this._reqCaps.clear(20);
        this._reqCaps.clear(25);
        this._reqCaps.clear(26);
        this._reqCaps.clear(31);
        this._reqCaps.clear(32);
        this._reqCaps.clear(33);
        this._reqCaps.clear(34);
        this._reqCaps.clear(35);
        this._reqCaps.clear(36);
        this._reqCaps.clear(37);
        this._reqCaps.clear(38);
        this._reqCaps.clear(44);
        this._reqCaps.clear(45);
        this._reqCaps.clear(46);
        this._reqCaps.clear(47);
        this._reqCaps.clear(48);
        this._reqCaps.clear(49);
        this._reqCaps.clear(50);
        this._reqCaps.clear(51);
        this._reqCaps.clear(52);
        this._reqCaps.clear(53);
        this._reqCaps.clear(55);
        this._reqCaps.clear(56);
        this._respCaps.set(12);
        this._respCaps.set(13);
        this._respCaps.set(14);
        this._respCaps.set(19);
        this._respCaps.set(20);
        this._respCaps.set(26);
        this._respCaps.set(29);
        this._respCaps.set(30);
        this._respCaps.set(35);
        this._respCaps.set(37);
        this._respCaps.set(38);
        this._respCaps.set(39);
    }
}

