/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.Dumpable;
import com.sybase.jdbc2.tds.TdsInputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.DumpFilter;
import com.sybase.jdbc2.utils.DumpInfo;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class SrvColInfoToken
extends Token
implements Dumpable {
    public static final int TDS_STAT_RENAME = 32;
    private int _totalLength;
    private Vector _columns = new Vector();

    public SrvColInfoToken(TdsInputStream tdsInputStream) throws IOException {
        int n = this._totalLength = (int)tdsInputStream.readShort();
        while (n > 0) {
            ColumnInfo columnInfo = new ColumnInfo(tdsInputStream);
            this._columns.addElement(columnInfo);
            n -= columnInfo.getLength();
        }
        if (n < 0) {
            throw new IOException("Malformed ColInfo token lengths");
        }
    }

    public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
        DumpInfo dumpInfo = null;
        if (dumpFilter.includesToken(165)) {
            dumpInfo = dumpFilter.getDumpInfo();
            if (dumpFilter.includesDetail(0)) {
                dumpInfo.addInfo("Token", 1, "COLINFO Token (0x" + HexConverts.hexConvert(165, 1) + "); variable length.");
            } else {
                dumpInfo.addInfo("Token", 1, "COLINFO Token");
            }
            if (dumpFilter.includesDetail(1)) {
                dumpInfo.addInt("Length", 2, this._totalLength);
            }
            if (dumpFilter.includesDetail(3)) {
                Enumeration enumeration = this._columns.elements();
                while (enumeration.hasMoreElements()) {
                    ColumnInfo columnInfo = (ColumnInfo)enumeration.nextElement();
                    dumpInfo.addInfo(columnInfo.dump(dumpFilter));
                }
            }
        }
        return dumpInfo;
    }

    public int getTokenType() {
        return 165;
    }

    private class ColumnInfo
    implements Dumpable {
        private int _columnNo;
        private int _tableNo;
        private int _status;
        private String _name;

        protected ColumnInfo(TdsInputStream tdsInputStream) throws IOException {
            this._columnNo = tdsInputStream.readUnsignedByte();
            this._tableNo = tdsInputStream.readUnsignedByte();
            this._status = tdsInputStream.readUnsignedByte();
            if ((this._status & 0x20) != 0) {
                int n = tdsInputStream.readUnsignedByte();
                this._name = tdsInputStream.readString(n);
            }
        }

        public DumpInfo dump(DumpFilter dumpFilter) throws IOException {
            DumpInfo dumpInfo = dumpFilter.getDumpInfo();
            dumpInfo.addInt("Column Number", 1, this._columnNo);
            dumpInfo.addInt("Table Number", 1, this._tableNo);
            String[] stringArray = new String[]{"<unrecognized>", "<unrecognized>", "TDS_STAT_EXPR", "TDS_STAT_KEY", "TDS_STAT_HIDDEN", "TDS_STAT_RENAME"};
            dumpInfo.addBitfield("Status", 1, this._status, stringArray);
            if ((this._status & 0x20) != 0) {
                if (dumpFilter.includesDetail(1)) {
                    dumpInfo.addInt("Length of Column Name", 1, this._name.length());
                }
                dumpInfo.addText("Column Name", this._name.length(), this._name);
            }
            return dumpInfo;
        }

        protected int getLength() {
            int n = 3;
            if ((this._status & 0x20) != 0) {
                n += this._name.length();
            }
            return n;
        }

        public int getTokenType() {
            return -1;
        }
    }
}

